clear
set mem 400m
cd "C:\Documents and Settings\jwolfers\My Documents\Current\Justin@Wharton\Australian Happiness\Final data"
*cd "C:\Documents and Settings\Andrew Leigh\My publications\Aust - Happiness & Job Satisfaction\"
use ISSP&HDI.dta, clear
sort cty
merge cty using populationdata_2003
tab _merge
drop _merge
gen temp=pop if cty=="WLD"
egen worldpop=max(temp)
egen issp_pop=sum(pop) if issp2002~=.
gen coverage=issp_pop/worldpop
sum coverage

sort cty
merge cty using "gdp per capita 1995-2002", nokeep
tab _merge
drop _merge country_name
gen lngdp=ln(gdp2002)
reg issp2002 lngdp

reg issp2002 hdi

************
* Figure 1 *
************
#delimit;
twoway 
	(scatter issp2002 hdi if country~="Australia", mlabel(cty)) 
	(scatter issp2002 hdi if country=="Australia", sort msymbol(square) msize(large) mlabel(country) mlabsize(medium) mlabposition(9)) 
	(lfit issp2002 hdi, sort)  
	(lfit issp2002 hdi if country~="Bulgaria" & country~="Russia" & country~="Latvia" & country~="Slovakia" & country~="Hungary" & country~="Czech Republic", sort clpat(longdash))  
,
	ytitle("Happiness, ISSP 2002" "(1=Completely unhappy to 7=Completely happy)") 
	ylabel(, angle(horizontal)) 
	xtitle("UN Human Development Index (0-1)") 
	xlabel(0.75(.05)1) 
	title("Happiness and the Human Development Index", size(vlarge)) 
	subtitle("ISSP 2002 Data")
	legend(rows(3) order(3 "All Data: Happiness=3.8+1.6*HDI (t=2.3)" 4 "Excluding former Warsaw Pact countries") size(small)) 
	legend(position(5) ring(0) region(fcolor(none))) 
	legend(title("Regression Line", size(medsmall) justification(left))) 
	xsize(10) ysize(7.5);
#delimit cr

use WVS&HDI.dta, clear

************
* Figure 2 *
************
#delimit;
twoway 
	(scatter lifesat hdi if country~="Australia", sort mlabel(cty))
	(scatter lifesat hdi if country=="Australia", sort msymbol(square) msize(large) mlabel(countryname) mlabsize(medium) mlabposition(9)) 
	(lfit lifesat hdi, sort clpat(longdash))
,
	ytitle("Life Satisfaction, WVS" "Average Score (1='Dissatisfied' to 10='Satisfied')") 
	ylabel(, angle(horizontal)) xtitle("Human Development Index (0-1)") 
	xlabel(.4(.2)1) 
	title(Life Satisfaction and the Human Development Index)
	subtitle("World Values Survey")
	caption("Life Satisfaction = 1.9 + 5.7 * HDI (t=7.1)", ring(0) pos(11)) 
	legend(off)
	xsize(10) ysize(7.5) ;
#delimit cr

use WVS&HDI.dta, clear

************
* Figure 3 *
************
#delimit;
twoway 
	(scatter happ hdi if country~="Australia", sort mlabel(cty))
	(scatter happ hdi if country=="Australia", sort msymbol(square) msize(large) mlabel(countryname) mlabsize(medium) mlabposition(9)) 
	(lfit happ hdi, sort clpat(longdash))
,
	ytitle("Happiness, WVS" "Average Score (1='Not at all happy' to 4='Very happy')") 
	ylabel(, angle(horizontal)) xtitle("Human Development Index (0-1)") 
	xlabel(.4(.2)1) 
	title(Happiness and the Human Development Index)
	subtitle("World Values Survey")
	caption("Happiness = 2.7 + 0.4 * HDI (t=1.4)", ring(0) pos(12)) 
	legend(off)
	xsize(10) ysize(7.5) ;
#delimit cr

use WVS&HDI.dta, clear
replace cty="ROM" if cty=="ROU"
sort cty
merge cty using "gdp per capita 1995-2002", nokeep
tab _merge
drop _merge country_name
gen lngdp=ln(gdp2002)
gen gdp=gdp2002
reg happ lngdp
predict hfit

************
* Figure 5 *
************
#delimit;
twoway 
	(scatter happ gdp if country~="Australia", sort mlabel(cty))
	(scatter happ gdp if country=="Australia", sort msymbol(square) msize(large) mlabel(countryname) mlabsize(medium) mlabposition(9)) 
	(line hfit gdp, sort clpat(longdash))
,
	ytitle("Happiness, WVS" "Average Score (1='Not at all happy' to 4='Very happy')") 
	ylabel(, angle(horizontal)) xtitle("GDP per capita in US$ at PPP (log scale)") 
	yscale(range(2.5 3.65))
	xscale(log)
	xlabel(2000 5000 10000 20000 35000 60000) 
	title(Happiness and GDP Per Capita)
	subtitle("World Values Survey")
	caption("Happiness = 2.3 + 0.08 * Log GDP (t=2.5)", ring(0) pos(12)) 
	legend(off)
	xsize(10) ysize(7.5) ;
#delimit cr

reg lifesat lngdp
predict lfit

************
* Figure 4 *
************
#delimit;
twoway 
	(scatter lifesat gdp if country~="Australia", sort mlabel(cty))
	(scatter lifesat gdp if country=="Australia", sort msymbol(square) msize(large) mlabel(countryname) mlabsize(medium) mlabposition(9)) 
	(line lfit gdp, sort clpat(longdash))
,
	ytitle("Life Satisfaction, WVS" "Average Score (1='Dissatisfied' to 10='Satisfied')") 
	ylabel(, angle(horizontal)) xtitle("GDP per capita in US$ at PPP (log scale)") 
	yscale(range(4 8.5))
	xscale(log)
	xlabel(2000 5000 10000 20000 35000 60000) 
	title(Life Satisfaction and GDP Per Capita)
	subtitle("World Values Survey")
	caption("Life Satisfaction = -0.9 + 0.8 * Log GDP (t=8.3)", ring(0) pos(12)) 
	legend(off)
	xsize(10) ysize(7.5) ;
#delimit cr


